<?php
namespace model;

class Feature extends \Pawn\Model
{
	// Migration
	public static function migration()
	{
		return array
		(
			array('CREATE', array
			(
				'game_id'	=>	'INT UNSIGNED',
				'image'		=>	'VARCHAR(255) DEFAULT ""'
			))
		);
	}
	
	// Identifier
	public function __toString()
	{
		return $this->game->__toString();
	}
	
	// Validation
	public function columns($preset)
	{
		if($preset == 'administrate')
		{
			return array
			(
				'image'	=>	array('file', array('optional'=>true, 'file_type'=>'image', 'image_size'=>array(250, 125)))
			);
		}
		
		return array
		(
			'game_id'	=>	array('text', array('c_game_exists'=>array($this, 'game_exists')))
		);
	}
	
	public function game_exists($id)
	{
		return \model\Game::num_rows('WHERE id=?', $id, false);
	}
	
	// Administration
	const sortColumn = 'ts_create';
	const sortAscending = 0;
	
	public function listing()
	{
		return array
		(
			'game_id'	=>	$this->__toString(),
			'image'		=>	$this->img_enabled($this->image != ''),
			'ts_create'	=>	\Pawn::get_date($this->ts_create)
		);
	}
	
	public static function bulk()
	{
		return array
		(
			'remove'	=>	false,
			'spotlight'	=>	'edit'
		);
	}
	
	// Remove
	public function remove()
	{
		$this->game->featured = 0;
		
		$this->delete();
	}
	
	// Delete
	public function delete($files=array())
	{
		parent::delete(array
		(
			'image'	=>	'png'
		));
	}
}